package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaDelegAgrupConvExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bDelegAgrupConv.xls";
		InputStream inputStream = W83bTablaDelegAgrupConvExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        Map agrupaciones = (HashMap)contexto.get("w83bMapResultadosBean");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);     
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
        HSSFCell cell4;
        HSSFCell cell5;
        
        HSSFCellStyle centrado =  wb.createCellStyle();
		centrado.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        
        row = sheet.getRow((short)3); 
        cell = row.getCell((short)3);
        
        StringBuffer tituloImagenEs = new StringBuffer();
        StringBuffer tituloImagenEu = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEs = new StringBuffer();
        tituloImagenEu = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	        
        
        row = sheet.getRow((short)5); 
        cell = row.getCell((short)3);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
        
        
        row = sheet.getRow((short)7); 
        cell = row.getCell((short)0);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.delegAgrupConvHist",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.delegAgrupConvHist",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
        row = sheet.getRow((short)8); 
        cell = row.getCell((short)0); 
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}
        row = sheet.getRow((short)9);      

        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)2); 
        if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio())){
        	cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase());
        }
        
        cell = row.getCell((short)4); 
        cell2 = row.getCell((short)5);
        sheet.addMergedRegion(new Region((short)9,(short)4,(short)9,(short)5)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.agrupacion",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.agrupacion",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)6); 
        if(StringUtils.isNotEmpty(resultadoBean.getAgrupTxt())){
        	cell.setCellValue(resultadoBean.getAgrupTxt());
        }
        
        row = sheet.getRow((short)10); 
        
        cell = row.getCell((short)1); 
        cell2 = row.getCell((short)2); 
        sheet.addMergedRegion(new Region(10,Short.parseShort("1"),10,Short.parseShort("2")));//NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionDesde",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionDesde",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
        
        cell = row.getCell((short)4); 
        cell2 = row.getCell((short)5); 
        cell3 = row.getCell((short)6); 
        sheet.addMergedRegion(new Region(10,Short.parseShort("4"),10,Short.parseShort("6")));//NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionHasta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionHasta",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)7);        
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
        
        cell = row.getCell((short)8); 
        cell2 = row.getCell((short)9); 
        sheet.addMergedRegion(new Region(10,Short.parseShort("8"),10,Short.parseShort("9")));//NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.fregdefhasta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.fregdefhasta",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        cell = row.getCell((short)10); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        }
        
        Map mapAgrupOrdenado = new TreeMap(agrupaciones);
        Set ref = mapAgrupOrdenado.keySet();
        
        String[]valores;
        String[]valtotagrup;
        String agrupacion;
        String convenio;
        String sindicato;
        
        Map sindicatosagrup=new HashMap();
        Map sindicatosterrit=new HashMap();
        Map sindicatosordenado=new HashMap();
        Map sindicatosterritord=new HashMap();

        int numdelegados=0;
        int numdelagrup=0;
        int numdelterrit=0;
        int contador=10;
        int i=0;
        int tamanyo=0;
        int lineascuerpo=0;
        int pag=0;
	    for( Iterator it = ref.iterator(); it.hasNext();) {
	    	pag=pag+1;
	    	lineascuerpo=0;
	    	numdelagrup=0;
		    sindicatosagrup=new HashMap();//NOPMD
		   	contador=contador+2;
		   	lineascuerpo=lineascuerpo+2;
		   	row = sheet.createRow((short)contador);
		    agrupacion=(String)it.next();
		    valores=agrupacion.split("\\|"); 
        	cell = row.createCell((short)1);
        	if (W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)){
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.agrupacion",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.agrupacion",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+valores[0]+"-"+valores[2]);
        	}
        	else{
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.agrupacion",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.agrupacion",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+valores[0]+"-"+valores[1]);
        	}
        	contador=contador+2;
        	lineascuerpo=lineascuerpo+2;
        	row = sheet.createRow((short)contador);
    		cell = row.createCell((short)0);
    		cell.setCellStyle(styleTextoImparCentrado(excel));
    		cell2 = row.createCell((short)1);
    		cell2.setCellStyle(styleTextoImparCentrado(excel));
    		cell3 = row.createCell((short)2);
    		cell3.setCellStyle(styleTextoImparCentrado(excel));
    		cell4 = row.createCell((short)3);
    		cell4.setCellStyle(styleTextoImparCentrado(excel));
    		cell5 = row.createCell((short)4);
    		cell5.setCellStyle(styleTextoImparCentrado(excel));
    		sheet.addMergedRegion(new Region((short)contador,(short)0,(short)contador,(short)4));//NOPMD
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.denominacionconvenio",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.denominacionconvenio",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
    		cell = row.createCell((short)5);
    		cell.setCellStyle(styleTextoImparCentrado(excel));
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cod",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cod",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
    		cell = row.createCell((short)6);
    		cell.setCellStyle(styleTextoImparCentrado(excel));
    		cell2 = row.createCell((short)7);
    		cell2.setCellStyle(styleTextoImparCentrado(excel));
    		cell3 = row.createCell((short)8);
    		cell3.setCellStyle(styleTextoImparCentrado(excel));
    		cell4 = row.createCell((short)9);
    		cell4.setCellStyle(styleTextoImparCentrado(excel));
    		sheet.addMergedRegion(new Region((short)contador,(short)6,(short)contador,(short)9));//NOPMD
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.sindicato",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.sindicato",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
    		cell = row.createCell((short)10);
    		cell.setCellStyle(styleTextoImparCentrado(excel));
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.num",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.num",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
    		cell = row.createCell((short)11);
    		cell.setCellStyle(styleTextoImparCentrado(excel));
    		cell.setCellValue("%");
        	Map mapConveniosOrdenado = new TreeMap((Map)mapAgrupOrdenado.get(agrupacion));//NOPMD
            Set refc = mapConveniosOrdenado.keySet();
            contador=contador+1;
            lineascuerpo=lineascuerpo+1;
        	for(Iterator itconv = refc.iterator(); itconv.hasNext();){
        		convenio=(String)itconv.next();
        		valores=convenio.split("\\|");
        		row = sheet.createRow((short)contador);
        		cell = row.createCell((short)0);
        		cell2 = row.createCell((short)1);
        		cell3 = row.createCell((short)2);
        		cell4 = row.createCell((short)3);
        		cell5 = row.createCell((short)4);
        		sheet.addMergedRegion(new Region((short)contador,(short)0,(short)contador,(short)4));//NOPMD
        		if (W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)){
        			cell.setCellValue(String.valueOf(quitarCeros(valores[0])+"-"+valores[2]));
        		}
        		else{
        			cell.setCellValue(String.valueOf(quitarCeros(valores[0])+"-"+valores[1]));
        		}
        		HSSFCellStyle estilo =  wb.createCellStyle();
        		estilo.setWrapText(true);
        		cell.setCellStyle(estilo);
        		if(!StringUtils.isEmpty(valores[0])){
    	        	tamanyo = (quitarCeros(valores[0])+"-"+valores[1]).length()/55;      	
            	}
        		lineascuerpo=lineascuerpo+tamanyo;
    		    row.setHeightInPoints((short)(15*(tamanyo+1)));
        		numdelegados=0;
        		List mapValues = new ArrayList(((HashMap)mapConveniosOrdenado.get(convenio)).values());//NOPMD
        		for (int j=0;j<=mapValues.size()-1;j++){
        			valores=String.valueOf(mapValues.get(j)).split("\\|");
             		numdelegados=numdelegados+Integer.parseInt(valores[0]);
             	}
        		numdelagrup=numdelagrup+numdelegados;
        		numdelterrit=numdelterrit+numdelegados;
        		Map mapSindicatosOrdenado = W83bUtilidadesComunes.getSortedMap((Map)mapConveniosOrdenado.get(convenio));//NOPMD
                Set refs = mapSindicatosOrdenado.keySet();
                i=0;
                for(Iterator itsind = refs.iterator(); itsind.hasNext();){
                	if (i!=0){
                		contador=contador+1;
                		lineascuerpo=lineascuerpo+1;
                		row = sheet.createRow((short)contador);
                	}
                	sindicato=(String)itsind.next();
                	valores=String.valueOf(mapSindicatosOrdenado.get(sindicato)).split("\\|");
                	sindicatosagrup=W83bUtilidadesComunes.listaSindAgrupConv(sindicatosagrup, sindicato, valores[0]);
                	sindicatosterrit=W83bUtilidadesComunes.listaSindAgrupConv(sindicatosterrit, sindicato, valores[0]);
            		valores=sindicato.split("\\|");
            		cell = row.createCell((short)5);            		
            		cell.setCellStyle(centrado);
            		cell.setCellValue(W83bUtilidades.numero(valores[0]));
            		cell = row.createCell((short)6);
            		cell2 = row.createCell((short)7);
            		cell3 = row.createCell((short)8);
            		cell4 = row.createCell((short)9);
            		sheet.addMergedRegion(new Region((short)contador,(short)6,(short)contador,(short)9));//NOPMD
            		if (W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)){
            			cell.setCellValue(valores[2]);
            		}
            		else{
            			cell.setCellValue(valores[1]);
            		}
            		cell = row.createCell((short)10);
            		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
            		valores=String.valueOf(mapSindicatosOrdenado.get(sindicato)).split("\\|");
            		cell.setCellValue(Integer.parseInt(valores[0]));
            		cell = row.createCell((short)11);
            		cell.setCellStyle(stylePorcentajesDcha(excel));
            		cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),numdelegados));
            		i=i+1;
                } 
                if (itconv.hasNext()){
                	contador=contador+2;
                	lineascuerpo=lineascuerpo+2;
                }
        	}
        	contador=contador+2;
        	lineascuerpo=lineascuerpo+2;
        	row = sheet.createRow((short)contador);
        	cell = row.createCell((short)0);
    		cell.setCellStyle(bordeArriba(excel));
    		cell2 = row.createCell((short)1);
    		cell2.setCellStyle(bordeArriba(excel));
    		cell3 = row.createCell((short)2);
    		cell3.setCellStyle(bordeArriba(excel));
    		cell4 = row.createCell((short)3);
    		cell4.setCellStyle(bordeArriba(excel));
    		cell5 = row.createCell((short)4);
    		cell5.setCellStyle(bordeArriba(excel));
    		sheet.addMergedRegion(new Region((short)contador,(short)0,(short)contador,(short)3));//NOPMD
    		cell = row.createCell((short)5);
    		cell.setCellStyle(bordeArriba(excel));
    		cell = row.createCell((short)6);
    		cell2 = row.createCell((short)7);
    		cell3 = row.createCell((short)8);
    		cell4 = row.createCell((short)9);
    		cell.setCellStyle(bordeArriba(excel));
	    	cell2.setCellStyle(bordeArriba(excel));
	    	cell3.setCellStyle(bordeArriba(excel));
	    	cell4.setCellStyle(bordeArriba(excel));
    		sheet.addMergedRegion(new Region((short)contador,(short)6,(short)contador,(short)9));//NOPMD
    		cell = row.createCell((short)10);
    		cell.setCellStyle(bordeArriba(excel));
    		cell = row.createCell((short)11);
    		cell.setCellStyle(bordeArriba(excel));
        	contador=contador+1;
        	lineascuerpo=lineascuerpo+1;
        	row = sheet.createRow((short)contador);
    		cell = row.createCell((short)0);
    		cell2 = row.createCell((short)1);
    		cell3 = row.createCell((short)2);
    		cell4 = row.createCell((short)3);
    		cell5 = row.createCell((short)4);
    		sheet.addMergedRegion(new Region((short)contador,(short)0,(short)contador,(short)4));//NOPMD
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalagrupacion",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalagrupacion",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
    		sindicatosordenado=W83bUtilidadesComunes.getSortedMap(sindicatosagrup);
    		Iterator iter = sindicatosordenado.entrySet().iterator();
    		Map.Entry e;
    		i=0;
    		while (iter.hasNext()) {
    			if (i!=0){
            		contador=contador+1;
            		lineascuerpo=lineascuerpo+1;
            		row = sheet.createRow((short)contador);
            	}
    			e = (Map.Entry)iter.next();
    			valores=String.valueOf(e.getKey()).split("\\|");
    		    cell = row.createCell((short)5);
    		    cell.setCellStyle(centrado);
    		    cell.setCellValue(W83bUtilidades.numero(valores[0]));
    		    cell = row.createCell((short)6);
        		cell2 = row.createCell((short)7);
        		cell3 = row.createCell((short)8);
        		cell4 = row.createCell((short)9);
        		sheet.addMergedRegion(new Region((short)contador,(short)6,(short)contador,(short)9));//NOPMD
        		if (W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)){
        			cell.setCellValue(valores[2]);
        		}
        		else{
        			cell.setCellValue(valores[1]);
        		}
    		    cell = row.createCell((short)10);
    		    cell.setCellStyle(styleCentradoNumeroFormateado(excel));
    		    valtotagrup=(String.valueOf(e.getValue())).split("\\|");
    		    cell.setCellValue(Integer.parseInt(valtotagrup[0]));
    		    cell = row.createCell((short)11);
    		    cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(valtotagrup[0]),numdelagrup));
    		    cell.setCellStyle(stylePorcentajesDcha(excel));
    		    i=i+1;
    		}  
    		if (it.hasNext()){
    	   		int paginas=0;
        		int lineasrestantes=0;
        		int lineasultimapagina=0;
        		 //Paginacin
        		//Si es la primera pgina tengo que tener en cuenta la cabecera, va a tener de cuerpo 60 lneas
        		if (pag==1){
        			//Si la agrupacin tiene menos de, o 60 lneas, calculo las que quedan hasta 60
        			if (lineascuerpo<=60){
        				lineasrestantes=60-lineascuerpo;
        			}
        			//Si tiene ms de 60 lneas, calculo cuntas pginas va a ocupar, teniendo en cuenta que la primera tiene 60 lneas de cuerpo y las siguientes 69 (69 la primera de la agrupacin y las otras 70)
        			else{
        				lineascuerpo=lineascuerpo-60;
        				if (lineascuerpo<=69){
        					paginas=1;
            				lineasultimapagina=60+(paginas*69);
            				//Calculo cuntas lneas quedan para completar la ltima pgina
            				lineasrestantes=lineasultimapagina-lineascuerpo-60;
        				}
        				else{
        					lineascuerpo=lineascuerpo-69;
        					paginas=1+(lineascuerpo/70);
            				lineasultimapagina=60+69+(paginas*70);
            				lineasrestantes=lineasultimapagina-lineascuerpo-60-69;
        				}
        				
        			}
        		}
        		else{
        			//Si no es la primera pgina, la primera pgina de la agrupcin tiene 69 lneas, pero las restantes 70 
        			if (lineascuerpo<=69){
        				lineasrestantes=69-lineascuerpo;
        			}
        			else{
        				lineascuerpo=lineascuerpo-69;
        				paginas=1+(lineascuerpo/70);
        				lineasultimapagina=69+(paginas*70);
        				lineasrestantes=lineasultimapagina-lineascuerpo-69;
        			}
        		}
        	   contador=contador+lineasrestantes;
    		}
 
	   }
	   
	   	contador=contador+2;
   		row = sheet.createRow((short)contador);
   		cell = row.createCell((short)0);
		cell2 = row.createCell((short)1);
		cell3 = row.createCell((short)2);
		cell4 = row.createCell((short)3);
		cell5 = row.createCell((short)4);
		cell.setCellStyle(bordeArriba(excel));
    	cell2.setCellStyle(bordeArriba(excel));
    	cell3.setCellStyle(bordeArriba(excel));
    	cell4.setCellStyle(bordeArriba(excel));
    	cell5.setCellStyle(bordeArriba(excel));
		sheet.addMergedRegion(new Region((short)contador,(short)0,(short)contador,(short)4));//NOPMD
		cell = row.createCell((short)5);
		cell.setCellStyle(bordeArriba(excel));
		cell = row.createCell((short)6);
	    cell2 = row.createCell((short)7);
	    cell3 = row.createCell((short)8);
	    cell4 = row.createCell((short)9);
	    cell.setCellStyle(bordeArriba(excel));
    	cell2.setCellStyle(bordeArriba(excel));
    	cell3.setCellStyle(bordeArriba(excel));
    	cell4.setCellStyle(bordeArriba(excel));
	    sheet.addMergedRegion(new Region((short)contador,(short)6,(short)contador,(short)9));//NOPMD
	    cell = row.createCell((short)10);
		cell.setCellStyle(bordeArriba(excel));
		cell = row.createCell((short)11);
		cell.setCellStyle(bordeArriba(excel));
   		contador=contador+1;
   		row = sheet.createRow((short)contador);
		cell = row.createCell((short)0);
		cell2 = row.createCell((short)1);
		cell3 = row.createCell((short)2);
		cell4 = row.createCell((short)3);
		cell5 = row.createCell((short)4);
		sheet.addMergedRegion(new Region((short)contador,(short)0,(short)contador,(short)4));//NOPMD
		if (!"".equals(resultadoBean.getDescTerritorio())){
   			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_CASTELLANO));
   		}
   		else{
   			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_CASTELLANO));
   		}
		sindicatosterritord=W83bUtilidadesComunes.getSortedMap(sindicatosterrit);
		Iterator iter = sindicatosterritord.entrySet().iterator();
		Map.Entry e;
		i=0;
		while (iter.hasNext()) {
			if (i!=0){
				contador=contador+1;
				row = sheet.createRow((short)contador);
			}
			e = (Map.Entry)iter.next();
			valores=String.valueOf(e.getKey()).split("\\|");
		    cell = row.createCell((short)5);
		    cell.setCellStyle(centrado);
		    cell.setCellValue(W83bUtilidades.numero(valores[0]));
		    cell = row.createCell((short)6);
		    cell2 = row.createCell((short)7);
		    cell3 = row.createCell((short)8);
		    cell4 = row.createCell((short)9);
		    sheet.addMergedRegion(new Region((short)contador,(short)6,(short)contador,(short)9));//NOPMD
		    if (W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)){
		    	cell.setCellValue(valores[2]);
		    }
		    else{
		    	cell.setCellValue(valores[1]);
		    }
		    cell = row.createCell((short)10);
		    cell.setCellStyle(styleCentradoNumeroFormateado(excel));
		    valtotagrup=(String.valueOf(e.getValue())).split("\\|");
		    cell.setCellValue(Integer.parseInt(valtotagrup[0]));
		    cell = row.createCell((short)11);
		    cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(valtotagrup[0]),numdelterrit));
		    cell.setCellStyle(stylePorcentajesDcha(excel));
		    i=i+1;
		}  		
	    
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);       
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoDelegPorAgrupConv.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle stylePorcentajesDcha(W83bUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;			
		
	}
	
	
	private HSSFCellStyle bordeArriba(W83bUtilidadesExcel excel){
		return excel.styleBordeArriba;			
		
	}

	private HSSFCellStyle styleTextoImparCentrado(W83bUtilidadesExcel excel){
		return excel.styleTextoImparCentrado;			
		
	}

	private HSSFCellStyle styleCentradoNumeroFormateado(W83bUtilidadesExcel excel){
		return excel.styleCentradoNumeroFormateado;			
		
	}
	
	private String quitarCeros(String valor){
		String str="";
		for (int i=0; i<valor.length(); i++){
			if (valor.charAt(i)!='0'){
				str=valor.substring(i,valor.length());
				break;
			}
		}
		return str;
	}

}
